/** @file   AlienFireballBullet.h
 * @brief   Declaration of AlienFireballBullet class.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/04/25 18:00:47 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_ALIENFIREBALLBULLET_H
#define H_WWW_ALIENFIREBALLBULLET_H

#include "bullet.h"

namespace WeWantWar {

/** @class  AlienFireballBullet
 * @brief   Represents the fireballs shot by some aliens.
 * @author  Tomi Lamminsaari
 *
 */
class AlienFireballBullet : public Bullet
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================
  

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   * @param   aShooter          Pointer to GameObject who shot this.
   * @param   aPos              Starting position.
   */
  AlienFireballBullet( GameObject* aShooter, const eng2d::Vec2D& aPos );

  /** Destructor
   */
  ~AlienFireballBullet();

private:
  
  /** Copy constructor
   * @param   aAnother          Reference to another AlienFireballBullet
   */
  AlienFireballBullet( const AlienFireballBullet& aAnother );

  /** An assignment operator
   * @param   aAnother          Reference to another AlienFireballBullet
   * @return  Reference to this object.
   */
  AlienFireballBullet& operator= ( const AlienFireballBullet& aAnother );

public:
  

  ///
  /// Inherited methods
  /// =================

  /** Draws this bullet.
   * @param   aBitmap           Pointer to target bitmap.
   */
  virtual void redraw( BITMAP* aBitmap ) const;
  
};

};  // end of namespace

#endif
